unit glCalendar;

//=============================================
//
//    LIVE calendar
//    Author: David "DavesLord" Caouette
//    Description: This is the render of the 3D calendar
//
//=============================================

interface

uses
   ComCtrls,
   Graphics,
   SysUtils,
   OpenGL;

var
   CalTex: glUInt;
   Calendar: TMonthCalendar;
   CalBitmap: TBitmap;
   OldDate: TDateTime;

procedure RenderCalendar(X, Y, Z: glFloat);

implementation

uses glRender, Textures;

procedure RenderCalendar(X, Y, Z: glFloat);
begin
   if Date > OldDate then
   // This comparison MUST be used to increase performance 
   begin
      Calendar := TMonthCalendar.CreateParented(h_Wnd);
      // Using this TMonthCalendar constructor
      // eliminates the TComponent dependency
      
      {Calendar.Width := 176;  // Must use these settings
      Calendar.Height := 154; // To remove the borders}
      // FIX: the above statements must be in comments
      // to fix the issue under NT-based platforms

      CalBitmap := TBitmap.Create;
      CalBitmap.Width := Calendar.Width;
      CalBitmap.Height := Calendar.Height;
      CalBitmap.PixelFormat := pf24Bit;
      Calendar.PaintTo(CalBitmap.Canvas, 0, 0);
      CalBitmap.SaveToFile('lab\calbitmap.bmp'); // Create our calendar bitmap
      CalBitmap.Free;

      Calendar.Free;
      LoadTexture('lab\calbitmap.bmp', CalTex, false);
      OldDate := Date;
   end;
   glCullFace(GL_BACK);
   glBindTexture(GL_TEXTURE_2D, CalTex);
   glBegin(GL_QUADS);
      glTexCoord(0,0);glVertex3f(X-0.03, Y-0.5, Z-0.575);
      glTexCoord(1,0);glVertex3f(X-0.03, y-0.5, Z+0.575);
      glTexCoord(1,1);glVertex3f(X-0.03, Y+0.5, Z+0.575);
      glTexCoord(0,1);glVertex3f(X-0.03, Y+0.5, Z-0.575);
   glEnd;
   glCullFace(GL_FRONT);
end;

initialization
   OldDate := 0;
   // Everytime the app is launched, we insure
   // that our calendar bitmap will exist even if deleted

end.
