//=============================================
//
//    Camera class
//    Authors: Danie Heath
//    Description: Camera management
//    Procedures and Functions :
//      MoveCamera : Forward and backward movement of the camera.
//
//=============================================//

unit glCamera;

interface

uses
  glTypes;

type
  TCamera = Object
    public
      vPosition : TVertex;
      Keys : Array [0..255] of Boolean;
      procedure MoveForward (MoveSpeed : Single);
      procedure MoveBackward (MoveSpeed : Single);
      procedure MoveLeft (MoveSpeed : Single);
      procedure MoveRight (MoveSpeed : Single);
    private
  end;

implementation

uses glRender;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

procedure TCamera.MoveForward (MoveSpeed : Single);
//Forward movement of the camera.

begin
  X := X - sin(Heading*pi/180)*FrameTime/MoveSpeed;   // FrameTime/600=movement speed
  Z := Z + cos(Heading*pi/180)*FrameTime/MoveSpeed;   // FrameTime/600=movement speed
  HeadMovAngle :=HeadMovAngle + 5;
  HeadMovement :=0.025*sin(HeadMovAngle*pi/180);
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

procedure TCamera.MoveBackward (MoveSpeed : Single);
//Backward movement of the camera.

begin
  X := X + sin(Heading*pi/180)*FrameTime/600;
  Z := Z - cos(Heading*pi/180)*FrameTime/600;
  HeadMovAngle :=HeadMovAngle - 5;
  HeadMovement :=0.025*sin(HeadMovAngle*pi/180);
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

procedure TCamera.MoveLeft (MoveSpeed : Single);
begin
  X := X + sin((Heading+90)*pi/180)*FrameTime/900;  // FrameTime/900=movement speed
  Z := Z - cos((Heading+90)*pi/180)*FrameTime/900;  // straffing = 50% slower
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

procedure TCamera.MoveRight (MoveSpeed : Single);
begin
  X := X - sin((Heading+90)*pi/180)*FrameTime/900;
  Z := Z + cos((Heading+90)*pi/180)*FrameTime/900;
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

end.
