unit glClock;

//=============================================
//
//    LIVE 3D CLOCK
//    Author: David "DavesLord" Caouette
//    Description: This is the render of the 3D clock
//
//=============================================

interface

uses OpenGL,
   SysUtils,
   glTypes;

var
   // ===== Clock
   ClockTex: glUInt;
   Needles: array[0..3, 0..3] of TVertex;
   // =====

procedure RenderClock(X, Y, Z: GLFloat);
procedure LoadClockTextures;

implementation

uses glRender, Textures;

procedure LoadClockTextures;
begin
   LoadTexture('lab\CLOCK.JPG', ClockTex, false);
end;

procedure RenderClock(X, Y, Z: GLFloat);
var
   AHrs, AMin, ASec, AMSec: Word;
begin
   DecodeTime(Time, AHrs, AMin, ASec, AMSec);
//=================================================

	Needles[SECNEEDLE,0].x := 0;
	Needles[SECNEEDLE,0].y := 0.5;
	Needles[SECNEEDLE,0].z := -0.04;

	Needles[SECNEEDLE,1].x := -0.005;
	Needles[SECNEEDLE,1].y := -0.01;
	Needles[SECNEEDLE,1].z := -0.04;

	Needles[SECNEEDLE,2].x := 0.005;
	Needles[SECNEEDLE,2].y := -0.01;
	Needles[SECNEEDLE,2].z := -0.04;

//=================================================

	Needles[MINNEEDLE,0].x := 0;
	Needles[MINNEEDLE,0].y := 0.5;
	Needles[MINNEEDLE,0].z := -0.03;

	Needles[MINNEEDLE,1].x := -0.01;
	Needles[MINNEEDLE,1].y := -0.01;
	Needles[MINNEEDLE,1].z := -0.03;

	Needles[MINNEEDLE,2].x := 0.01;
	Needles[MINNEEDLE,2].y := -0.01;
	Needles[MINNEEDLE,2].z := -0.03;


//=================================================

	Needles[HRSNEEDLE,0].x := 0;
	Needles[HRSNEEDLE,0].y := 0.4;
	Needles[HRSNEEDLE,0].z := -0.02;

	Needles[HRSNEEDLE,1].x := -0.01;
	Needles[HRSNEEDLE,1].y := -0.01;
	Needles[HRSNEEDLE,1].z := -0.02;

	Needles[HRSNEEDLE,2].x := 0.01;
	Needles[HRSNEEDLE,2].y := -0.01;
	Needles[HRSNEEDLE,2].z := -0.02;

//=================================================
   glCullFace(GL_BACK);
   glBindTexture(GL_TEXTURE_2D, ClockTex);
   glBegin(GL_QUADS);
      glTexCoord(0,0);glVertex3f(X-0.01, Y-0.75,     Z-0.75);
      glTexCoord(1,0);glVertex3f(X-0.01, Y-0.75,     Z+0.75);
      glTexCoord(1,1);glVertex3f(X-0.01, Y+0.75, Z+0.75);
      glTexCoord(0,1);glVertex3f(X-0.01, Y+0.75, Z-0.75);
   glEnd;
   glCullFace(GL_FRONT);

   glPushMatrix;
   glTranslatef(X, Y, Z);
   glRotatef(90, 0, 1, 0);

   glPushMatrix;
   glDisable(GL_LIGHTING);
   glDisable(GL_TEXTURE_2D);
   glRotatef(ASec * 6, 0, 0, 1);
   glBegin(GL_TRIANGLES);
         glColor3f(1.0, 0.0, 0.0);glVertex3fv(@Needles[SECNEEDLE, 0]);
         glColor3f(1.0, 0.0, 0.0);glVertex3fv(@Needles[SECNEEDLE, 1]);
         glColor3f(1.0, 0.0, 0.0);glVertex3fv(@Needles[SECNEEDLE, 2]);
   glEnd;
   glEnable(GL_TEXTURE_2D);
   glEnable(GL_LIGHTING);
   glPopMatrix;

   glPushMatrix;
   glRotatef(AMin * 6 + ASec / 10, 0, 0, 1);
   glBegin(GL_TRIANGLES);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[MINNEEDLE, 0]);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[MINNEEDLE, 1]);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[MINNEEDLE, 2]);
   glEnd;
   glPopMatrix;

   glPushMatrix;
   glRotatef(AHrs * 30 + AMin / 2, 0, 0, 1);
   glBegin(GL_TRIANGLES);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[HRSNEEDLE, 0]);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[HRSNEEDLE, 1]);
         glColor3f(0.0, 0.0, 0.0);glVertex3fv(@Needles[HRSNEEDLE, 2]);
   glEnd;
   glPopMatrix;

   glPopMatrix;   
end;

end.
