unit glDoors;

//=============================================
//
//    WOODEN DOORS
//    Author: David "DavesLord" Caouette
//    Description: To render the corridors wooden doors
//
//=============================================

interface

uses OpenGL, Windows;

procedure RenderDoor(X, Y, Z: glFloat; ThetaY: glFloat);
procedure LoadDoorDispList;
procedure ProcessDoor(DoorNum: integer);

const
   REBOOT   = 0;
   SHUTDOWN = 1;
   LOGOFF   = 2;
   STANDBY  = 3;

var
   DoorTex: glUInt;
   DoorList: glUInt;

implementation

uses glRender, Textures;

procedure RenderDoor(X, Y, Z: glFloat; ThetaY: glFloat);
begin   
   glPushMatrix;
      glTranslatef(X, Y, Z);
      glRotatef(ThetaY, 0, -1, 0);
      glCallList(DoorList);
   glPopMatrix;
end;

procedure LoadDoorDispList;
begin
   LoadTexture('lab\WOODDOOR.JPG', DoorTex, false);
   DoorList := glGenLists(1);
   glNewList(DoorList, GL_COMPILE);
      glBindTexture(GL_TEXTURE_2D, DoorTex);
      glDisable(GL_CULL_FACE);  
      glBegin(GL_QUADS);
         // Door panel
         glTexCoord(0,0);glVertex3f(-0.35,1.0, 0.005);
         glTexCoord(1,0);glVertex3f(0.35, 1.0, 0.005);
         glTexCoord(1,1);glVertex3f(0.35, 0.0, 0.005);
         glTexCoord(0,1);glVertex3f(-0.35,0.0, 0.005);

         glTexCoord(0,0);glVertex3f(0.35, 1.0, -0.005);
         glTexCoord(1,0);glVertex3f(-0.35, 1.0,-0.005);
         glTexCoord(1,1);glVertex3f(-0.35, 0.0,-0.005);
         glTexCoord(0,1);glVertex3f(0.35, 0.0, -0.005);

         // Door left frame
         glTexCoord(0,0);glVertex3f(-0.4,  1.05, 0.05);
         glTexCoord(1,0);glVertex3f(-0.35, 1.05, 0.05);
         glTexCoord(1,1);glVertex3f(-0.35, 0.0, 0.05);
         glTexCoord(0,1);glVertex3f(-0.4,  0.0, 0.05);
         
         glTexCoord(0,0);glVertex3f(-0.4, 1.05, 0.05);
         glTexCoord(1,0);glVertex3f(-0.4, 1.05, -0.05);
         glTexCoord(1,1);glVertex3f(-0.4, 0.0, -0.05);
         glTexCoord(0,1);glVertex3f(-0.4, 0.0, 0.05);

         glTexCoord(0,0);glVertex3f(-0.35, 1.05, -0.05);
         glTexCoord(1,0);glVertex3f(-0.35, 1.05, 0.05);
         glTexCoord(1,1);glVertex3f(-0.35, 0.0, 0.05);
         glTexCoord(0,1);glVertex3f(-0.35, 0.0, -0.05);

         glTexCoord(0,0);glVertex3f(-0.35, 1.05, -0.05);
         glTexCoord(1,0);glVertex3f(-0.4,  1.05, -0.05);
         glTexCoord(1,1);glVertex3f(-0.4,  0.0, -0.05);
         glTexCoord(0,1);glVertex3f(-0.35, 0.0, -0.05);

         // Door Right frame
         glTexCoord(0,0);glVertex3f(0.35,1.05, 0.05);
         glTexCoord(1,0);glVertex3f(0.4, 1.05, 0.05);
         glTexCoord(1,1);glVertex3f(0.4, 0.0, 0.05);
         glTexCoord(0,1);glVertex3f(0.35,0.0, 0.05);
         
         glTexCoord(0,0);glVertex3f(0.4, 1.05, -0.05);
         glTexCoord(1,0);glVertex3f(0.4, 1.05, 0.05);
         glTexCoord(1,1);glVertex3f(0.4, 0.0, 0.05);
         glTexCoord(0,1);glVertex3f(0.4, 0.0, -0.05);

         glTexCoord(0,0);glVertex3f(0.35, 1.05, 0.05);
         glTexCoord(1,0);glVertex3f(0.35, 1.05, -0.05);
         glTexCoord(1,1);glVertex3f(0.35, 0.0, -0.05);
         glTexCoord(0,1);glVertex3f(0.35, 0.0, 0.05);

         glTexCoord(0,0);glVertex3f(0.4, 1.05, -0.05);
         glTexCoord(1,0);glVertex3f(0.35,1.05, -0.05);
         glTexCoord(1,1);glVertex3f(0.35,0.0, -0.05);
         glTexCoord(0,1);glVertex3f(0.4, 0.0, -0.05);

         // Door Top frame
         glTexCoord(0,0);glVertex3f(-0.4, 1.05, 0.05);
         glTexCoord(1,0);glVertex3f(0.4,  1.05, 0.05);
         glTexCoord(1,1);glVertex3f(0.4,  1.0,  0.05);
         glTexCoord(0,1);glVertex3f(-0.4, 1.0,  0.05);         

         glTexCoord(0,0);glVertex3f(0.4,  1.05, -0.05);
         glTexCoord(1,0);glVertex3f(-0.4, 1.05, -0.05);
         glTexCoord(1,1);glVertex3f(-0.4, 1.0,  -0.05);
         glTexCoord(0,1);glVertex3f(0.4,  1.0,  -0.05);

         glTexCoord(0,0);glVertex3f(0.4,  1.05, -0.05);
         glTexCoord(1,0);glVertex3f(-0.4, 1.05, -0.05);
         glTexCoord(1,1);glVertex3f(-0.4, 1.05, 0.05);
         glTexCoord(0,1);glVertex3f(0.4,  1.05, 0.05);

         glTexCoord(0,0);glVertex3f(0.4,  1.0, -0.05);
         glTexCoord(1,0);glVertex3f(-0.4, 1.0, -0.05);
         glTexCoord(1,1);glVertex3f(-0.4, 1.0, 0.05);
         glTexCoord(0,1);glVertex3f(0.4,  1.0, 0.05);         

      glEnd;
      glEnable(GL_CULL_FACE);
   glEndList;
end;

procedure ProcessDoor(DoorNum: integer);
begin
   case DoorNum of
      REBOOT:  begin                  
                  HintToRender := 'Rebooting system...';
                  ToolHUDState := True;
                  glKillWnd(True);
                  ExitWindowsEx(EWX_REBOOT, 0);
               end;
      SHUTDOWN:begin
                  HintToRender := 'Shutdowning system...';
                  ToolHUDState := True;
                  glKillWnd(True);                  
                  ExitWindowsEx(EWX_SHUTDOWN, 0);
               end;
      STANDBY: begin
                  HintToRender := 'Entering stand-by mode...';
                  ToolHUDState := True;
                  SetSystemPowerState(true, true);
                  // Ok, I found how to workaround the OpenGL problem
                  // on resuming, so...
               end;
      LOGOFF:  begin
                  HintToRender := 'System is logging off...';
                  ToolHUDState := True;
                  {glKillWnd(True);
                  ExitWindowsEx(EWX_LOGOFF, 0);}
               end;
   end;
end;

end.
