unit glHUD;

//=============================================
//
//    Console GUI
//    Authors: David Caouette, Maarten McClaw Kronberger
//    Description: Crosshair, and hint about what is in sight
//
//=============================================

interface

uses OpenGL, Windows;

procedure BuildFont;
procedure KillFont;
procedure glWrite(X, Y : GLUint; text : PChar);
procedure RenderCrosshair;

var
   base : GLuint;                // base to the font display lists      

implementation

uses glRender, Textures;

{----------------------------------------------------------------}
{  Procedures used to create and write text                      }
{----------------------------------------------------------------}
procedure BuildFont;
var 
   font : HFONT;   
begin
  base := glGenLists(96);                  // Generate enough display lists to hold

  font := CreateFont(-12,                           // height of font
		     0,                             // average character width
		     0,                             // angle of escapement
		     0,                             // base-line orientation angle
		     FW_BOLD,                       // font weight
		     0,			            // italic
		     0,                             // underline
		     0,			            // strikeout
		     ANSI_CHARSET,                  // character set
		     OUT_TT_PRECIS,	            // output precision
		     CLIP_DEFAULT_PRECIS,           // clipping precision
		     ANTIALIASED_QUALITY,           // output quality
		     FF_DONTCARE or DEFAULT_PITCH,  // pitch and family
		     'OCR A Extended');             // font

  SelectObject(h_DC, font);               // Sets the new font as the current font in the device context  
  wglUseFontBitmaps(h_DC, 32, 96, base);  // Creates a set display lists containing the bitmap fonts
end;

procedure KillFont;
begin
  glDeleteLists(base, 96);                // Delete the font display lists, returning used memory
end;

procedure glWrite(X, Y : GLUint; text : PChar);
const
   RectOfs = 5;
var drawRect : TRect;
    txtSize: TSize;
begin
   GetTextExtentPoint32(h_DC, text, length(text), txtSize);   
   glPushAttrib(GL_DEPTH_TEST);     // Save the current Depth test settings (Used for blending )
      glDisable(GL_DEPTH_TEST);     // Turn off depth testing (otherwise we get no FPS)      
      glMatrixMode(GL_PROJECTION);  // Switch to the projection matrix
      glDisable(GL_TEXTURE_2D);     // Turn off textures, don't want our text textured
      glPushMatrix();               // Save current projection matrix
         glLoadIdentity();

         GetWindowRect(h_Wnd, drawRect);  // Get current window size
         glOrtho(0, drawRect.right, 0, drawRect.bottom, -1, 1);  // Change the projection matrix using an orthographic projection
         glMatrixMode(GL_MODELVIEW);  // Return to the modelview matrix
         glPushMatrix();              // Save the current modelview matrix
            glLoadIdentity();
            glDisable(GL_LIGHTING);
            
            glBegin(GL_POLYGON); 
               glVertex2i(X, drawRect.Bottom-Y);
               glVertex2i(X + txtSize.cx + RectOfs shl 1, drawRect.Bottom-Y); 
               glVertex2i(X + txtSize.cx + RectOfs shl 1, drawRect.Bottom-(Y + txtSize.cy + RectOfs shl 1));
               glVertex2i(X, drawRect.Bottom-(Y + txtSize.cy + RectOfs shl 1)); 
            glEnd();            

            glColor3ub(75, 0, 255);
            glRasterPos2i(X+(RectOfs), drawRect.Bottom-(Y+txtSize.cy+1));  // Position the Text            
            glPushAttrib(GL_LIST_BIT);                          // Save's the current base list
               glListBase(base - 32);                           // Set the base list to our character list
               glCallLists(length(text), GL_UNSIGNED_BYTE,      // Display the text
                  PChar(text));                                 
            glPopAttrib();                                      // Restore the old base list
            glEnable(GL_LIGHTING);
            glMatrixMode(GL_PROJECTION); // Switch to projection matrix
         glPopMatrix();                  // Restore the old projection matrix
         glMatrixMode(GL_MODELVIEW);// Return to modelview matrix
      glPopMatrix();                // Restore old modelview matrix      
      glEnable(GL_TEXTURE_2D);      // Turn on textures, don't want our text textured
   glPopAttrib();                   // Restore depth testing
end;

procedure RenderCrosshair;
var 
   drawRect : TRect;
begin
   glPushAttrib(GL_DEPTH_TEST);     // Save the current Depth test settings (Used for blending )
      glDisable(GL_DEPTH_TEST);     // Turn off depth testing (otherwise we get no FPS)      
      glMatrixMode(GL_PROJECTION);  // Switch to the projection matrix
      glDisable(GL_TEXTURE_2D);     // Turn off textures, don't want our text textured
      glPushMatrix();               // Save current projection matrix
         glLoadIdentity();
         GetWindowRect(h_Wnd, drawRect);  // Get current window size
         glOrtho(0, drawRect.right, 0, drawRect.bottom, -1, 1);  // Change the projection matrix using an orthographic projection
         glMatrixMode(GL_MODELVIEW);  // Return to the modelview matrix
         glPushMatrix();              // Save the current modelview matrix
            glLoadIdentity();
            glDisable(GL_LIGHTING);                        
            glColor3ub(0, 0, 0);
            glBegin(GL_LINES);
            
               glVertex2i(drawRect.right div 2, drawRect.bottom div 2 - 4);
               glVertex2i(drawRect.right div 2, drawRect.bottom div 2 - 2); 

               glVertex2i(drawRect.right div 2, drawRect.bottom div 2 + 3);
               glVertex2i(drawRect.right div 2, drawRect.bottom div 2 + 5); 
               
               glVertex2i(drawRect.right div 2 - 5, drawRect.bottom div 2);
               glVertex2i(drawRect.right div 2 - 3, drawRect.bottom div 2); 
               
               glVertex2i(drawRect.right div 2 + 2, drawRect.bottom div 2);
               glVertex2i(drawRect.right div 2 + 4, drawRect.bottom div 2); 
            glEnd();

            glEnable(GL_LIGHTING);
            glMatrixMode(GL_PROJECTION); // Switch to projection matrix
         glPopMatrix();                  // Restore the old projection matrix
         glMatrixMode(GL_MODELVIEW);// Return to modelview matrix
      glPopMatrix();                // Restore old modelview matrix      
      glEnable(GL_TEXTURE_2D);      // Turn on textures, don't want our text textured
   glPopAttrib();                   // Restore depth testing
end;

end.
