unit glPlanet;

//=============================================
//
//    Internet Connection and browser launcher
//    Author: David "DavesLord" Caouette
//    Description: All that is related to internet is here
//
//=============================================

interface

uses OpenGL, ShellAPI, Windows, WinInet;

var
   // ===== Textured rotating planet
   gluQuadObj: gluQuadricObj;       // Planet sphere
   PlanetTex: glUint;               // Planet texture
   PlanetYTheta: glUint;            // Planet rotation angle on Y-axis
   BaseTopTex, BaseFaceTex: glUInt; // Top base and side faces textures
   // =====

procedure RenderPlanet(X, Y, Z: GLFloat);
procedure LoadPlanetTextures;
procedure LaunchBrowser;

implementation

uses glRender, Textures;

procedure LoadPlanetTextures;
begin
   PlanetYTheta := 0; // Planet rotation angle
   gluQuadObj := gluNewQuadric;
   // Create A Pointer To The Quadric Object (Return 0 If No Memory) (NEW)
   gluQuadricNormals(gluQuadObj, GLU_SMOOTH);
   // Create Smooth Normals (NEW)
   gluQuadricTexture(gluQuadObj, GL_TRUE);
   // Create Texture Coords (NEW)

   glEnable(GL_TEXTURE_2D);          // Enable Texture Mapping
   glTexGenf(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
   glTexGenf(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

   LoadTexture('lab\EARTH.jpg', PlanetTex, false);
   LoadTexture('lab\TOPBASE.JPG', BaseTopTex, false);
   LoadTexture('lab\WALL5.JPG', BaseFaceTex, false);
end;

procedure RenderPlanet(X, Y, Z: GLFloat);
begin            
   glPushMatrix;   
   // Save current matrix state, useful if you don't
   // want to rotate or translate the whole matrix, but
   // only what you're rendering

   glBindTexture(GL_TEXTURE_2D, BaseTopTex);
   glBegin(GL_QUADS);
      glTexCoord(0,0);glVertex3f(X-0.45, Y-0.65, Z-0.45); // Top face
      glTexCoord(1,0);glVertex3f(X+0.45, Y-0.65, Z-0.45);
      glTexCoord(1,1);glVertex3f(X+0.45, Y-0.65, Z+0.45);
      glTexCoord(0,1);glVertex3f(X-0.45, Y-0.65, Z+0.45);
   glEnd;
   
   glBindTexture(GL_TEXTURE_2D, BaseFaceTex);
   glBegin(GL_QUADS);
      glTexCoord(0,0);glVertex3f(X+0.45, Y-0.65, Z-0.45); // North face
      glTexCoord(1,0);glVertex3f(X-0.45, Y-0.65, Z-0.45);
      glTexCoord(1,1);glVertex3f(X-0.45, 0.0,    Z-0.45);
      glTexCoord(0,1);glVertex3f(X+0.45, 0.0,    Z-0.45);

      glTexCoord(0,0);glVertex3f(X-0.45, Y-0.65, Z-0.45); // West face
      glTexCoord(1,0);glVertex3f(X-0.45, Y-0.65, Z+0.45); 
      glTexCoord(1,1);glVertex3f(X-0.45, 0.0,    Z+0.45);
      glTexCoord(0,1);glVertex3f(X-0.45, 0.0,    Z-0.45);
      
      glTexCoord(0,0);glVertex3f(X+0.45, Y-0.65, Z+0.45); // East face
      glTexCoord(1,0);glVertex3f(X+0.45, Y-0.65, Z-0.45);
      glTexCoord(1,1);glVertex3f(X+0.45, 0.0,    Z-0.45);
      glTexCoord(0,1);glVertex3f(X+0.45, 0.0,    Z+0.45);

      glTexCoord(0,0);glVertex3f(X-0.45, Y-0.65, Z+0.45); // South face
      glTexCoord(1,0);glVertex3f(X+0.45, Y-0.65, Z+0.45);
      glTexCoord(1,1);glVertex3f(X+0.45, 0.0,    Z+0.45);
      glTexCoord(0,1);glVertex3f(X-0.45, 0.0,    Z+0.45);
   glEnd;
   
   glCullFace(GL_BACK);                      // Must see the outer surface of the planet
   glBlendFunc(GL_SRC_ALPHA, GL_ONE);        // Making it transparently shining
   glEnable(GL_BLEND);

   glBindTexture(GL_TEXTURE_2D, PlanetTex);  // Bind Planet texture
   glTranslatef(X, Y, Z);                    // Put the planet where we want
   glRotatef(90, -1, 0, 0);                  // Rotate it to put it on the right axis
   Inc(PlanetYTheta);
   if PlanetYTheta > 360 then                // Reset angle if > 360 above
      PlanetYTheta := PlanetYTheta - 360;
   glRotatef(PlanetYTheta, 0, 0, 1);         // Make our planet rotating
   gluSphere(gluQuadObj, 0.6, 32, 32);
   glDisable(GL_BLEND);
   glCullFace(GL_FRONT);                     // reset the cullface to GL_FRONT

   glPopMatrix;
end;

procedure LaunchBrowser;
begin
   // We launch the internet browser
   
end;

end.
